# DeepSeek + 火山 - AI 海龟汤游戏项目实战

本项目是一个 AI 海龟汤游戏网站，通过 AI 对话的方式玩海龟汤游戏。

这是一个快速实战 Vibe Coding 的项目，从需求分析到开发完成只用了 2 个多小时。其中前端使用 AI 生成，后端手写代码调用 AI API。重点在于学习快速开发流程、Prompt 提示词工程、以及给程序增加 AI 能力的方法。

项目代码免费开源：https://github.com/liyupi/yuhaigui-ai-game

项目文字 + 视频教程：https://www.codefather.cn/course/1898973113527894017

下文为项目的成品介绍和演示效果。



---



大家好，我是程序员鱼皮，现在已经是全民 AI 时代了，咱们程序员更要想办法榨干 AI，把 AI 利用起来。前几天我一时兴起，直播用 2 多个小时的时间，从需求分析开始，带大家做了一个 AI 海龟汤游戏项目。

[代码也给大家开源出来了](https://github.com/liyupi/yuhaigui-ai-game)，供朋友们玩耍和学习：

![](https://pic.yupi.icu/1/image-20250311173906981.png)

下面简单介绍下这个项目~



## AI 海龟汤项目

几个小时就能学完的 AI 原生项目，通过做一个 AI 海龟汤游戏网站，带大家快速实战 AI 项目的开发流程，紧跟时代的前沿。

可能很多朋友没听说过海龟汤，这是一个老少咸宜的小游戏，分为汤面和汤底，主持人讲一个故事（汤面），由玩家通过提问的方式来不断地揭露还原故事的真相（汤底）。

举个例子：有一个人邀请朋友来参加生日聚会，在他吹完蜡烛后，他把在场的所有朋友都弄死了，问为什么？

![](https://pic.yupi.icu/1/image-20250311174206256.png)

可以让 AI 代替传统海龟汤的主持人，玩家只需要向 AI 对话，就能够自己进行海龟汤的游戏。

下面这个图就是用 AI 生成的网站，其实还可以再优化优化让它更好看~

![](https://pic.yupi.icu/1/1741583369760-09fd9c45-2093-4ab0-8148-ec83ad61fc6b.png)



通过这个小项目，其实还是能学到不少东西的：

1. 学习标准的企业项目开发流程：需求分析 => 方案设计 => 后端开发 + 前端开发 => 测试 => 部署上线（可选）
2. 学习如何快速初始化前后端项目
3. 学习在程序中接入 AI 大模型
4. 学习如何封装自己的 AI 工具类
5. 学习如何优化 Prompt
6. 学习如何维护对话上下文并传递给 AI
7. 学习如何利用 AI 补全代码
8. 学习如何纯利用 AI 开发前端网站



![接入 AI 并调试优化 Prompt 提示词](https://pic.yupi.icu/1/1741248993412-8e92e068-5192-46ad-81bc-bf046de4c005.png)



### 技术选型

#### 前端

- Vue 3：适合快速开发单页面应用
- Ant Design Vue：主流组件库，兼容 PC 端和移动端响应式
- Vue Router：前端路由组件
- Axios：主流的请求库

#### 后端

- Java + Spring Boot 框架
- MySQL 数据库
- MyBatis  + MyBatis Plus 框架
- Hutool 工具类
- Swagger + Knife4j 接口文档组合
- AI 大模型接入，此处接入的是目前很火的 DeepSeek



![快速初始后端 + 运行接口文档调试接口](https://pic.yupi.icu/1/1741247574417-a53861c4-35c6-488d-90a1-aa2cea31cee0.png)



### 业务流程

1. 玩家进入页面，点击【开始游戏】，进入聊天室页面
2. 进入聊天室页面时，AI 会立刻给出一个招呼语（给出故事汤面）
3. 接下来，用户可以和 AI 主持人进行对话
4. 用户可以主动结束，也可以由 AI 主动结束游戏
5. 用户可以随时查看往期的对话记录

流程如图，这个图也是利用 AI 生成出来的：

![](https://pic.yupi.icu/1/image-20250310135157204.png)



## 最后

这个项目的完整直播回放已经分集发到了 [编程导航网站](https://mp.weixin.qq.com/s/jHy2EjdOZPJDN_Lrs7qAUA) 上。除了上面这个项目外，最近我给编程导航的 [智能面试刷题平台项目](https://mp.weixin.qq.com/s/jHy2EjdOZPJDN_Lrs7qAUA) 也新增了不少 AI 的功能，比如 AI 生成题目和题解、AI 模拟面试等，都能够帮大家增加简历亮点并提升求职竞争力。

![AI 模拟面试](https://pic.yupi.icu/1/image-20250311175611501.png)

编程导航还有我带大家做过的 [20 多套项目教程](https://www.codefather.cn/post/1797431216467001345)，从 0 到 1 带大家实操全栈项目开发，很多朋友靠我的项目拿到了不错的 Offer，好评如潮~ 

![](https://pic.yupi.icu/1/de62f4cc-32cb-4814-aca7-03c232d0e2d2.png)




## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
